// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

// __Please ask for permission, if you want to use some code from this shader__

// __Discord: The Alexander # 3744__

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		in vec2 uv0;
		in vec2 uv1;
	#endif
#endif

#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformInterFrameConstants.h"
#include "util.h"

varying hmp vec3 cpos;
varying hmp vec3 wpos;
varying vec4 color;
varying float farrender;
varying float farchunk;

#ifdef UNDERWATER
varying float fogr;
#endif

/////////////////////////////
/////////// STOP! ///////////
// Code water by: @bambo_san
// Please, if you want to use the water code, ask @bambo_san for   
// permission, it does not cost anything
// Att: @The_AlexanderG
//////////////////////////////
//////////////////////////////

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

//https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/
vec3 acesFilmic(vec3 x){
    const float a = 2.51;
    const float b = 0.035;
    const float c = 2.43;
    const float d = 0.59;
    const float e = 0.15;
return clamp((x * (a * x + b)) / (x * (c * x + d) + e), 0.0, 1.0);
}

#include "lib/s_lib.h"
#define rain clamp((1.0-pow(FOG_CONTROL.y+.1,10.)),.0,1.)*uv1.y

vec3 calclight(vec3 c,float strength){
	vec3 lcolor = mix(vec3(dot(vec3(7.,4.,0)*strength,vec3(1.))),vec3(7.,4.,0)*strength,1.1);
	c += lcolor*pow(uv1.x*1.1,5.);
return c;
}

vec4 calcWater(vec4 c,vec4 btex,vec3 N,vec2 tt,vec2 ft,float rim){
	vec3 nw = normalize(vec3(calcWave(cpos.xz*5.)*0.6,calcWave(cpos.xz*5.)*0.65,1.));
	vec4 wcolor = vec4(c.rgb,.2);
	vec3 npos = normalize(wpos*vec3(1,1,6));
	float sm = (1.-rain)*max(0.,1.-length(npos.zy))*13.,slook = (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.25,0.,1.);
	float hmap = pow(dot(nw,normalize(vec3(.8,-1.,.8))),4.);
	wcolor.rgb = mix(wcolor.rgb,calclight(wcolor.rgb,mix(.1,0.,1.-tt.x)),(uv1.x+hmap*2.));
		c *= .5;
		c = mix(wcolor+hmap*btex.r,FOG_COLOR+min(1.2*slook*ft.y*3.5,1.)*(sm*hmap)*smoothstep(0.,0.8,uv1.y),FOG_CONTROL.x==0.?-rim*.5:rim*.8);
		c.a += pow(farchunk,5.);
return c;
}

vec3 calcFog(vec3 c,vec2 ft){
	vec3 norpos = normalize(wpos);
	float sunamount = max(0.,1.-length(norpos.zy)), sunlook = (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.25,0.,1.);
	vec3 fogcol = mix(FOG_COLOR.rgb,FOG_COLOR.rgb*1.5,sunamount*min(1.2*sunlook*ft.y*4.,1.));
return mix(c,fogcol,pow(farrender*.9,1.8));
}

void main()
{
#ifdef BYPASS_PIXEL_SHADER
	gl_FragColor = vec4(0, 0, 0, 0);
	return;
#else 
#if USE_TEXEL_AA
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv0);
	vec4 lm = texture2D_AA(TEXTURE_1, vec2(0,1));
#else
	vec4 diffuse = texture2D(TEXTURE_0, uv0);
	vec4 lm = texture2D(TEXTURE_1, vec2(0,1));
#endif

	vec4 btex = texture2D(TEXTURE_1,uv1);
	bool nether = ((FOG_COLOR.r > FOG_COLOR.b) && (FOG_COLOR.r < 0.5) && (FOG_COLOR.b < 0.2));
	bool water = (color.a < 0.95 && color.a > 0.05);
	hmp vec2 ttime = vec2(max(1.-min(pow(lm.r*1.8,5.),1.),.0),pow(clamp((1.-pow(lm.r,5.))*1.3,.0,1.),8.))*uv1.y;
	vec2 ftime = vec2(pow(max(min(1.0-FOG_COLOR.r*1.5,1.),.0),1.2),pow(max(min(1.0-FOG_COLOR.r*1.2,1.),.0),.5));

#ifdef SEASONS_FAR
	diffuse.a = 1.0;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
	#define ALPHA_THRESHOLD 0.05
	#else
	#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

	vec4 inColor = color;

#if defined(BLEND)
	diffuse.a *= inColor.a;
#endif

#if !defined(ALWAYS_LIT)
	diffuse *= btex;
#endif

#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = inColor.a;
	#endif

//torch
vec3 colorA = vec3(1.3,0.45,0.0);
vec3 colorB = vec3(1.2,0.40,0.0);
highp float ti = abs(sin(TIME));
vec3 light = mix(colorA,colorB,ti);
diffuse.rgb += light *max(uv1.x-0.45,0.0)*(1.0-diffuse.rgb);

//Fog

vec3 fog = mix(diffuse.rgb, FOG_COLOR.rgb*vec3(2.43,3.65,4.9), clamp(length(-wpos)/RENDER_DISTANCE*1.0,0.0,0.6));

//reduce default ambient occlusion
if(color.g * 2.0 > color.b + color.r && color.a != 0.){
	diffuse.rgb *= mix(normalize(inColor.rgb),inColor.rgb,0.5);
}else{
	diffuse.rgb *= color.a ==0.?inColor.rgb: sqrt(inColor.rgb);
}

//color
	diffuse.rgb *= pow(diffuse.rgb, vec3(.65,.65,.65));
	vec3 exposureBias = mix(mix(mix(vec3(2.,2.,2.),vec3(2.5,2.2,1.),ttime.y),vec3(2.,2.2,2.4),ttime.x),vec3(1),rain);
	vec3 curr = acesFilmic(exposureBias*diffuse.rgb);
	diffuse.rgb = curr;

#else
	vec2 uv = inColor.xy;
	diffuse.rgb *= mix(vec3(1.0,1.0,1.0), texture2D( TEXTURE_2, uv).rgb*2.0, inColor.b);
	diffuse.rgb *= inColor.aaa;
	diffuse.a = 1.0;
#endif

#ifdef FANCY
	vec3 N = normalize(cross(dFdx(cpos.xyz),dFdy(cpos.xyz)));
#endif
	float smap = 0.,rim = pow(smoothstep(0.,1.,1.-dot(N,normalize(-wpos))),2.);
#if !USE_ALPHA_TEST
       smap = mix(smap, 1., clamp(abs(-N.x), 0., 1.)); smap = mix(smap, 1., clamp((-N.z + N.y), 0., 1.) * ttime.y*(1.- ttime.x));
   #endif
 
highp float ub = smoothstep(.87, .84, uv1.y);
    smap = mix(smap, 1., ub);
	
#if !defined(SEASONS) && !defined(ALPHA_TEST)
if(bool(water)==true)diffuse = calcWater(diffuse,btex,N,ttime,ftime,rim);
#endif

#ifdef UNDERWATER
if(bool(water)==false)diffuse = vec4(vec3(.3,.7,1.),.0)*diffuse + max(0.,calcWave(cpos.xz*5.5))*uv1.y*diffuse;

	diffuse.rgb += (1.-uv1.y)*pow(uv1.x*1., 4.)*vec3(1,1,1)*diffuse.rgb;
	diffuse.rgb = mix(diffuse.rgb,FOG_COLOR.rgb,pow(fogr,7.));

if(bool(water)==false){
vec3 sea = vec3(0.1,0.1,0.2);
vec3 source = vec3(0.0,0.0,2.0);
diffuse.rgb += sea*uv1.x;
diffuse.rgb += diffuse.rgb* (source)* pow(uv1.x, 60.0)* (1.0-uv1.y);}

if(nether==true){

vec3 nether_fog = mix(diffuse.rgb, FOG_COLOR.rgb*vec3(5.5,5.5,5.5), clamp(length(-wpos)/RENDER_DISTANCE*1.0,0.0,0.4));

diffuse.rgb = nether_fog;
}

#endif
	diffuse.rgb *= mix(1.,.6,smap*(1.-rain)*(1.-max(0.,2.*uv1.x-0.8)));
	diffuse.rgb = calcFog(diffuse.rgb,ftime);

	gl_FragColor = diffuse;
#endif // BYPASS_PIXEL_SHADER
}